package ru.yandex.direct.common.jackson.jaxbmodule;

import javax.xml.bind.JAXBElement;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;


/**
 * JaxbElementDeserializers предоставляет десериализатор для ссылочного типа для {@code JAXBElement},
 * созданного в {@link JaxbElementTypeModifier}
 */
public class JaxbElementDeserializers extends Deserializers.Base {

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config,
                                                    BeanDescription beanDesc) throws JsonMappingException {
        if (type.getRawClass() != JAXBElement.class) {
            // если это не JAXBElement обрабатываем стандартно
            return super.findBeanDeserializer(type, config, beanDesc);
        }

        JavaType refType = type.getBindings().getTypeParameters().get(0);

        JsonDeserializer<?> valueDeser = refType.getValueHandler();
        TypeDeserializer typeDeser = refType.getTypeHandler();
        if (typeDeser == null) {
            typeDeser = config.findTypeDeserializer(refType);
        }
        return new JaxbElementDeserializer(type, refType, typeDeser, valueDeser);
    }
}
