package ru.yandex.direct.common.jackson.jaxbmodule;

import java.io.IOException;

import javax.xml.bind.JAXBElement;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.Serializers;

/**
 * Наши кастомные сериализаторы.
 * На данный момент, сериализатор для JAXBElement (холдер для значения, у которого 3 состояния:
 * значения есть (JAXBElement.value), значение nil(JAXBElement.isNil), значение не передано (=null)
 */
class JaxbElementSerializers extends Serializers.Base {
    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        if (type.getRawClass() == JAXBElement.class) {
            return new JaxbElementSerializer();
        } else {
            return super.findSerializer(config, type, beanDesc);
        }
    }

    private static class JaxbElementSerializer extends JsonSerializer<JAXBElement> {
        @Override
        public void serialize(JAXBElement value, JsonGenerator gen, SerializerProvider serializers)
                throws IOException, JsonProcessingException {
            if (value.isNil()) {
                gen.writeNull();
            } else {
                gen.writeObject(value.getValue());
            }
        }
    }
}
