package ru.yandex.direct.common.jackson.jaxbmodule;

import java.lang.reflect.Type;

import javax.xml.bind.JAXBElement;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;


/**
 * Конструирует {@link ReferenceType} из {@link JAXBElement}
 *
 * @see JaxbElementDeserializers
 */
public class JaxbElementTypeModifier extends TypeModifier {
    @Override
    public JavaType modifyType(JavaType type, Type jdkType, TypeBindings bindings, TypeFactory typeFactory) {
        final Class<?> raw = type.getRawClass();

        if (JAXBElement.class.isAssignableFrom(raw)) {
            JavaType[] types = typeFactory.findTypeParameters(type, JAXBElement.class);
            JavaType t = (types == null || types.length == 0) ? null : types[0];
            if (t == null) {
                t = TypeFactory.unknownType();
            }

            return typeFactory.constructParametricType(
                    JAXBElement.class, t
            );
        }
        return type;
    }
}
