package ru.yandex.direct.common.jackson.jaxbmodule;

import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;

public class JaxbModule extends SimpleModule {
    @Override
    public void setupModule(SetupContext context) {

        // поддержка JAXBElement
        context.addDeserializers(new JaxbElementDeserializers());
        context.addTypeModifier(new JaxbElementTypeModifier());
        context.insertAnnotationIntrospector(new JaxbAnnotationIntrospector(context.getTypeFactory()));

        if (context.getOwner() instanceof XmlMapper) {
            // Игнорирование пробелов в тэгах включаем только для XML
            context.addBeanDeserializerModifier(new IgnoreWhitespacesBeanDeserializerModifier());
        } else {
            // Json-сериализатор JAXBElement
            context.addSerializers(new JaxbElementSerializers());
        }

        super.setupModule(context);
    }
}
