package ru.yandex.direct.common.jetty;

import com.google.common.collect.ImmutableMap;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.direct.solomon.SolomonUtils;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * Сбор информации о jetty
 */
@Component
@Lazy(false)
public class JettyMetricProvider {
    private static final String JETTY = "jetty";
    private static final String STATS_BEAN_NAME = "org.eclipse.jetty.server.handler:type=statisticshandler,id=0";
    private static final ImmutableMap<String, String> STATS_ATTRIBUTES = new ImmutableMap.Builder<String, String>()
            .put("requestsActive", "requests_active")
            .put("requestsActiveMax", "requests_active_max")
            .put("requests", "requests")
            .put("responses2xx", "responses_2xx")
            .put("responses3xx", "responses_3xx")
            .put("responses4xx", "responses_4xx")
            .put("responses5xx", "responses_5xx")
            .build();

    private static final String POOL_BEAN_NAME = "org.eclipse.jetty.util.thread:type=queuedthreadpool,id=0";
    private static final ImmutableMap<String, String> POOL_ATTRIBUTES = new ImmutableMap.Builder<String, String>()
            .put("threads", "threads")
            .put("minThreads", "min_threads")
            .put("maxThreads", "max_threads")
            .put("idleThreads", "idle_threads")
            .put("busyThreads", "busy_threads")
            .build();

    public JettyMetricProvider() {
        SolomonUtils.registerJmxAttributes(JETTY, Labels.of("type", "stats"), STATS_BEAN_NAME, STATS_ATTRIBUTES);
        SolomonUtils.registerJmxAttributes(JETTY, Labels.of("type", "thread_pool"), POOL_BEAN_NAME, POOL_ATTRIBUTES);
    }
}
