package ru.yandex.direct.common.jooqmapper;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;
import ru.yandex.direct.jooqmapper.write.JooqWriterBuilder;

import static com.google.common.base.Preconditions.checkState;

/**
 * @deprecated use {@link JooqMapperWithSupplierBuilder}
 * or {@link JooqMapperBuilder}
 * or {@link JooqReaderBuilder}
 * or {@link JooqReaderWithSupplierBuilder}
 * or {@link JooqWriterBuilder}
 * instead.
 */
@Deprecated
@ParametersAreNonnullByDefault
public class OldJooqMapperBuilder<T> {

    private final Supplier<T> modelSupplier;
    private final Function<T, T> modelPostprocessor;
    private final List<FieldMapper<?, ? super T, ?, ?>> mappers = new ArrayList<>();

    public OldJooqMapperBuilder() {
        this.modelSupplier = null;
        this.modelPostprocessor = null;
    }

    public OldJooqMapperBuilder(Supplier<T> modelSupplier) {
        this(modelSupplier, null);
    }

    public OldJooqMapperBuilder(Supplier<T> modelSupplier, @Nullable Function<T, T> modelPostprocessor) {
        this.modelSupplier = modelSupplier;
        this.modelPostprocessor = modelPostprocessor;
    }

    /**
     * Конструирование маппера на основе существующего {@link OldJooqMapper}.
     *
     * @param sourceMapper  исходный маппер, из которого будут втянуты все маппинги полей.
     * @param modelSupplier генератор инстанса модели, {@link Supplier}.
     */
    public OldJooqMapperBuilder(OldJooqMapper<? super T> sourceMapper, Supplier<T> modelSupplier) {
        this(modelSupplier, null);
        sourceMapper.mappers().forEach(mappers::add);
    }

    /**
     * Добавляет маппер для чтения/записи поля модели из/в БД
     *
     * @param fieldMapper маппер значений из/в БД
     * @return возвращает себя
     */
    public OldJooqMapperBuilder<T> map(FieldMapper<?, ? super T, ?, ?> fieldMapper) {
        mappers.add(fieldMapper);
        return this;
    }

    public OldJooqMapperWithSupplier<T> build() {
        checkState(modelSupplier != null, "builder must have a model supplier");

        return new OldJooqMapperWithSupplier<>(modelSupplier, mappers, modelPostprocessor);
    }

    public OldJooqMapper<T> buildWithoutModelSupplier() {
        checkState(modelSupplier == null, "builder must have no model supplier");

        return new OldJooqMapper<>(mappers, modelPostprocessor);
    }

}
