package ru.yandex.direct.common.jooqmapper;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.write.JooqWriter;

/**
 * Реализация {@link OldJooqMapper}, способная самостоятельно инстанцировать
 * модель при маппинге из записи в БД и предоставляющая метод {@link #fromDb(Record)},
 * который не требует модели на вход.
 * <p>
 * Может быть получен отдельно, а также из имеющегося маппера {@link OldJooqMapper}
 * при помощи конструктора {@link OldJooqMapperBuilder#OldJooqMapperBuilder(OldJooqMapper, Supplier)}.
 *
 * @param <M> тип модели
 * @deprecated use {@link JooqMapper}
 * or {@link JooqMapperWithSupplier}
 * or {@link JooqReader}
 * or {@link JooqReaderWithSupplier}
 * or {@link JooqWriter}
 * instead.
 */
@Deprecated
@ParametersAreNonnullByDefault
public final class OldJooqMapperWithSupplier<M> extends OldJooqMapper<M> {

    /**
     * Возвращает экземпляр модели для последующего заполнения при чтении из базы.
     */
    private final Supplier<M> modelSupplier;

    OldJooqMapperWithSupplier(Supplier<M> modelSupplier, List<FieldMapper<?, ? super M, ?, ?>> mappers,
                              @Nullable Function<M, M> modelPostprocessor) {
        super(mappers, modelPostprocessor);
        this.modelSupplier = modelSupplier;
    }

    /**
     * Получает экземпляр модели из заданного в конструкторе {@code modelSupplier}
     * и заполняет его данными из переданной записи в БД, используя предварительно заданные мапперы.
     * <p>
     * Поддерживает частичное заполнение модели, то есть в переданной записи могут находиться
     * не все поля таблицы, для которых зарегистрированы мапперы. Соответственно, будут применены
     * только те мапперы, которые читают поля, присутствующие в записи.
     * <p>
     * Поддерживает заполнение из нескольких таблиц, т.е. в переданной записи могут одновременно
     * находиться значения из разных таблиц.
     *
     * @param record запись в БД, из которой необходимо заполнить модель
     * @return экземпляр модели, заполненный из переданной записи в БД
     */
    public M fromDb(Record record) {
        return fromDb(modelSupplier.get(), record);
    }

}
