package ru.yandex.direct.common.liveresource.yav

import com.google.common.cache.CacheLoader
import com.google.common.util.concurrent.ExecutionList
import com.google.common.util.concurrent.ListenableFuture
import ru.yandex.direct.yav.client.YavClient
import java.util.concurrent.CompletableFuture
import java.util.concurrent.Executor
import java.util.concurrent.Future

class YavCacheLoader(private val yavClient: YavClient) : CacheLoader<String, Map<String, String>>() {
    override fun load(key: String): Map<String, String> = yavClient.getSecretValues(key)
    override fun reload(key: String, oldValue: Map<String, String>): ListenableFuture<Map<String, String>> =
        SimpleListenableFromCompletableFuture(yavClient.getSecretValuesFuture(key))
}

private class SimpleListenableFromCompletableFuture<T>(
    private val completableFuture: CompletableFuture<T>
) : ListenableFuture<T>, Future<T> by completableFuture {

    private val executionList = ExecutionList()

    init {
        completableFuture.handle { _, _ -> executionList.execute() }
    }

    override fun addListener(listener: Runnable, executor: Executor) {
        if (completableFuture.isDone) {
            listener.run()
        }
        executionList.add(listener, executor)
    }
}
