package ru.yandex.direct.common.liveresource.yav

import com.google.common.cache.LoadingCache
import ru.yandex.direct.liveresource.LiveResource

class YavLiveResource(private val versionOrSecretUuid: String,
                      private val keyName: String,
                      private val yavCachedSecrets: LoadingCache<String, Map<String, String>>) : LiveResource {

    override fun getContent(): String = yavCachedSecrets[versionOrSecretUuid][keyName]
        ?: throw IllegalArgumentException("Can't find key = $keyName")

    override fun getLocation(): String = "$versionOrSecretUuid#$keyName"
}
