package ru.yandex.direct.common.liveresource.zookeeper;

import java.nio.charset.StandardCharsets;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.curator.framework.CuratorFramework;
import org.springframework.scheduling.TaskScheduler;

import ru.yandex.direct.libs.curator.CuratorFrameworkProvider;
import ru.yandex.direct.liveresource.LiveResourceReadException;
import ru.yandex.direct.liveresource.LiveResourceWatcher;
import ru.yandex.direct.liveresource.WatchableLiveResource;
import ru.yandex.direct.utils.ThreadUtils;

@ParametersAreNonnullByDefault
public class ZookeeperLiveResource implements WatchableLiveResource {

    private String location;
    private CuratorFrameworkProvider curatorFrameworkProvider;

    public ZookeeperLiveResource(String location, CuratorFrameworkProvider curatorFrameworkProvider) {
        this.location = location;
        this.curatorFrameworkProvider = curatorFrameworkProvider;
    }

    @Override
    public String getContent() {
        CuratorFramework curatorFramework = curatorFrameworkProvider.getDefaultCurator();
        try {
            return new String(curatorFramework.getData().forPath(location), StandardCharsets.UTF_8);
        } catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            throw new LiveResourceReadException("Cannot read zookeeper file " + location, e);
        }
    }

    @Override
    public String getLocation() {
        return location;
    }

    @Override
    public LiveResourceWatcher createWatcher(TaskScheduler taskScheduler) {
        return new ZookeeperLiveResourceWatcher(this, curatorFrameworkProvider, taskScheduler);
    }
}
