package ru.yandex.direct.common.liveresource.zookeeper;

import java.net.URI;

import org.checkerframework.checker.nullness.qual.NonNull;

import ru.yandex.direct.libs.curator.CuratorFrameworkProvider;
import ru.yandex.direct.liveresource.LiveResource;
import ru.yandex.direct.liveresource.provider.LiveResourceProvider;

public class ZookeeperLiveResourceProvider implements LiveResourceProvider {

    private CuratorFrameworkProvider curatorFrameworkProvider;

    public ZookeeperLiveResourceProvider(CuratorFrameworkProvider curatorFrameworkProvider) {
        this.curatorFrameworkProvider = curatorFrameworkProvider;
    }

    @Override
    public @NonNull String getScheme() {
        return "zk";
    }

    @Override
    public LiveResource get(URI uri) {
        return new ZookeeperLiveResource(uri.getPath(), curatorFrameworkProvider);
    }
}
