package ru.yandex.direct.common.log.container;

import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

public class LogActiveOrdersData {
    @JsonProperty("OrderID")
    private long orderId;
    @JsonProperty("Shows")
    private long shows;
    @JsonProperty("Clicks")
    private long clicks;
    @JsonProperty("CostCur")
    private long costCur;
    @JsonProperty("Cost")
    private long cost;
    @JsonProperty("SpentUnits")
    private long spentUnits;
    @JsonProperty("UpdateTime")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;

    public LogActiveOrdersData(long orderId) {
        this.orderId = orderId;
    }

    public LogActiveOrdersData withShows(long shows) {
        this.shows = shows;
        return this;
    }

    public LogActiveOrdersData withClicks(long clicks) {
        this.clicks = clicks;
        return this;
    }

    public LogActiveOrdersData withCostCur(long costCur) {
        this.costCur = costCur;
        return this;
    }

    public LogActiveOrdersData withSpentUnits(long spentUnits) {
        this.spentUnits = spentUnits;
        return this;
    }

    public LogActiveOrdersData withUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public LogActiveOrdersData withCost(long cost) {
        this.cost = cost;
        return this;
    }
}
