package ru.yandex.direct.common.log.container;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;

public class LogCampaignBalanceData {

    @JsonProperty("cid")
    private long cid;

    @JsonProperty("type")
    private String type;

    @JsonProperty("currency")
    private String currency;

    @JsonProperty("ClientID")
    private long clientId;

    @JsonProperty("tid")
    private long tid;

    @JsonProperty("sum")
    private BigDecimal sum;

    @JsonProperty("sum_delta")
    private BigDecimal sumDelta;

    @JsonProperty("sum_balance")
    private BigDecimal sumBalance;

    public LogCampaignBalanceData() {
    }

    @SuppressWarnings("checkstyle:parameternumber")
    public LogCampaignBalanceData(long cid, String type, String currency, long clientId, long tid, BigDecimal sum,
                                  BigDecimal sumDelta, BigDecimal sumBalance) {
        this.cid = cid;
        this.type = type;
        this.currency = currency;
        this.clientId = clientId;
        this.tid = tid;
        this.sum = sum;
        this.sumDelta = sumDelta;
        this.sumBalance = sumBalance;
    }

    public long getCid() {
        return cid;
    }

    public LogCampaignBalanceData withCid(long cid) {
        this.cid = cid;
        return this;
    }

    public String getType() {
        return type;
    }

    public LogCampaignBalanceData withType(String type) {
        this.type = type;
        return this;
    }

    public String getCurrency() {
        return currency;
    }

    public LogCampaignBalanceData withCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public long getClientId() {
        return clientId;
    }

    public LogCampaignBalanceData withClientId(long clientId) {
        this.clientId = clientId;
        return this;
    }

    public long getTid() {
        return tid;
    }

    public LogCampaignBalanceData withTid(long tid) {
        this.tid = tid;
        return this;
    }

    public BigDecimal getSum() {
        return sum;
    }

    public LogCampaignBalanceData withSum(BigDecimal sum) {
        this.sum = sum;
        return this;
    }

    public BigDecimal getSumDelta() {
        return sumDelta;
    }

    public LogCampaignBalanceData withSumDelta(BigDecimal sumDelta) {
        this.sumDelta = sumDelta;
        return this;
    }

    public BigDecimal getSumBalance() {
        return this.sumBalance;
    }

    public LogCampaignBalanceData withSumBalance(BigDecimal sumBalance) {
        this.sumBalance = sumBalance;
        return this;
    }
}
