package ru.yandex.direct.common.log.container;

import java.net.InetAddress;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class LogEntry<T> {
    /**
     * Поле uid может отсутствовать и выводить его в json не нужно
     */
    @JsonProperty("log_time")
    private String logTime;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("uid")
    private Long uid;
    @JsonProperty("method")
    private String method;
    @JsonProperty("service")
    private String service;

    @JsonProperty("ip")
    private InetAddress ip;
    @JsonProperty("reqid")
    private long reqId;
    @JsonProperty("log_hostname")
    private String logHostname;
    @JsonProperty("log_type")
    private LogType logType;

    @JsonProperty("data")
    private T data;

    public Long getUid() {
        return uid;
    }

    public LogEntry<T> withUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public String getMethod() {
        return method;
    }

    public LogEntry<T> withMethod(String method) {
        this.method = method;
        return this;
    }

    public String getService() {
        return service;
    }

    public LogEntry<T> withService(String service) {
        this.service = service;
        return this;
    }

    public InetAddress getIp() {
        return ip;
    }

    public LogEntry<T> withIp(InetAddress ip) {
        this.ip = ip;
        return this;
    }

    public long getReqId() {
        return reqId;
    }

    public LogEntry<T> withReqId(long reqId) {
        this.reqId = reqId;
        return this;
    }

    public String getLogHostname() {
        return logHostname;
    }

    public LogEntry<T> withLogHostname(String logHostname) {
        this.logHostname = logHostname;
        return this;
    }

    public String getLogTime() {
        return logTime;
    }

    public LogEntry<T> withLogTime(String logTime) {
        this.logTime = logTime;
        return this;
    }

    public LogType getLogType() {
        return logType;
    }

    public LogEntry<T> withLogType(LogType logType) {
        this.logType = logType;
        return this;
    }

    public T getData() {
        return data;
    }

    public LogEntry<T> withData(T data) {
        this.data = data;
        return this;
    }
}
