package ru.yandex.direct.common.log.container;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.currency.CurrencyCode;

public class LogPriceData {
    @JsonProperty("cid")
    private long cid;
    @JsonProperty("pid")
    private long pid;
    @JsonProperty("bid")
    private long bid;
    @JsonProperty("id")
    private long id;
    @JsonProperty("price_ctx")
    private Double priceCtx;
    @JsonProperty("price")
    private Double price;
    @JsonProperty("type")
    private OperationType type;
    @JsonProperty("currency")
    private CurrencyCode currency;

    public enum OperationType {
        UPDATE("update"),
        INSERT_1("insert1"),
        UPDATE_1("update1"),
        UPDATE_2("update2"),
        UPDATE_ZERO_CONTEXT_PRICES("update_zero_context_prices"),
        RESTORE_MANUAL_PRICES("restore_manual_prices"),
        DELETE_1("delete1"),
        RET_ADD("ret_add"),
        RET_UPDATE("ret_update"),
        DYN_COND_ADD("dyn_condition_create"),
        DYN_COND_UPDATE("dyn_condition_update"),
        DELETE_2("delete2"),
        PERF_FILTER_CREATE("perf_filter_create"),
        PERF_FILTER_UPDATE("perf_filter_update");
        // todo maxlog (DIRECT-68270): пока не ясно, какие конкретно названия у типов операций должны быть

        private final String name;

        OperationType(String name) {
            this.name = name;
        }

        @Override
        @JsonValue
        public String toString() {
            return name;
        }
    }

    /**
     * bid нет в аргументах конструктора, т.к он всегда = 0, со временем это поле будет удалено
     */
    public LogPriceData(long cid, long pid, long id, Double priceCtx, Double price,
                        CurrencyCode currency, OperationType type) {
        this.cid = cid;
        this.pid = pid;
        this.bid = 0;
        this.id = id;
        this.priceCtx = priceCtx;
        this.price = price;
        this.currency = currency;
        this.type = type;
    }

    public long getCid() {
        return cid;
    }

    public LogPriceData withCid(long cid) {
        this.cid = cid;
        return this;
    }

    public long getPid() {
        return pid;
    }

    public LogPriceData withPid(long pid) {
        this.pid = pid;
        return this;
    }

    public long getBid() {
        return bid;
    }

    public LogPriceData withBid(long bid) {
        this.bid = bid;
        return this;
    }

    public long getId() {
        return id;
    }

    public LogPriceData withId(long id) {
        this.id = id;
        return this;
    }

    public Double getPriceCtx() {
        return priceCtx;
    }

    public LogPriceData withPriceCtx(Double priceCtx) {
        this.priceCtx = priceCtx;
        return this;
    }

    public Double getPrice() {
        return price;
    }

    public LogPriceData withPrice(Double price) {
        this.price = price;
        return this;
    }

    public CurrencyCode getCurrency() {
        return currency;
    }

    public LogPriceData withCurrency(CurrencyCode currency) {
        this.currency = currency;
        return this;
    }

    public OperationType getType() {
        return type;
    }

    public LogPriceData withType(OperationType type) {
        this.type = type;
        return this;
    }
}
