package ru.yandex.direct.common.log.container;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

@SuppressWarnings({"FieldCanBeLocal", "unused"})
public class LogUaasData {
    @JsonProperty("ClientID")
    private Long clientId;
    @JsonProperty("yandexuid")
    private String yandexUid;
    @JsonProperty("exp_boxes")
    private String expBoxes;
    @JsonProperty("features")
    private String features;
    @JsonProperty("config_versiob")
    private String configVersion;

    public LogUaasData withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public LogUaasData withYandexUid(String yandexUid) {
        this.yandexUid = yandexUid;
        return this;
    }

    public LogUaasData withExpBoxes(String expBoxes) {
        this.expBoxes = expBoxes;
        return this;
    }

    public LogUaasData withFeatures(String features) {
        this.features = features;
        return this;
    }

    public LogUaasData withConfigVersion(String configVersion) {
        this.configVersion = configVersion;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogUaasData that = (LogUaasData) o;
        return Objects.equals(clientId, that.clientId) &&
                Objects.equals(yandexUid, that.yandexUid) &&
                Objects.equals(expBoxes, that.expBoxes) &&
                Objects.equals(features, that.features) &&
                Objects.equals(configVersion, that.configVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, yandexUid, expBoxes, features, configVersion);
    }

    @Override
    public String toString() {
        return "LogUaasData{" +
                "clientId=" + clientId +
                ", yandexUid='" + yandexUid + '\'' +
                ", expBoxes='" + expBoxes + '\'' +
                ", features='" + features + '\'' +
                ", configVersion='" + configVersion + '\'' +
                '}';
    }
}
