package ru.yandex.direct.common.log.container;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ModerationLogEntry<T> {
    @JsonProperty("log_time")
    private String logTime;
    @JsonProperty("cid")
    private long cid;
    @JsonProperty("pid")
    private long pid;
    @JsonProperty("bid")
    private long bid;
    @JsonProperty("span_id")
    private long spanId;
    @JsonProperty("action")
    private Action action;
    @JsonProperty("source")
    private Source source;
    @JsonProperty("success")
    private boolean success;
    @JsonProperty("data")
    private T data;

    public ModerationLogEntry(long cid, long pid, long bid, Action action, boolean success, T data) {
        this.cid = cid;
        this.pid = pid;
        this.bid = bid;
        this.action = action;
        this.success = success;
        this.data = data;
    }

    @JsonCreator
    public ModerationLogEntry(
            @JsonProperty("cid") long cid, @JsonProperty("pid") long pid, @JsonProperty("bid") long bid,
            @JsonProperty("action") Action action, @JsonProperty("source") Source source,
            @JsonProperty("success") boolean success, @JsonProperty("data")T data) {
        this.cid = cid;
        this.pid = pid;
        this.bid = bid;
        this.action = action;
        this.source = source;
        this.success = success;
        this.data = data;
    }

    public String getLogTime() {
        return logTime;
    }

    public void setLogTime(String logTime) {
        this.logTime = logTime;
    }

    public long getCid() {
        return cid;
    }

    public long getPid() {
        return pid;
    }

    public long getBid() {
        return bid;
    }

    public long getSpanId() {
        return spanId;
    }

    public void setSpanId(long spanId) {
        this.spanId = spanId;
    }

    public Action getAction() {
        return action;
    }

    public Source getSource() {
        return source;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public T getData() {
        return data;
    }

    @Override
    public String toString() {
        return "ModerationLogEntry{" +
                "logTime='" + logTime + '\'' +
                ", cid=" + cid +
                ", pid=" + pid +
                ", bid=" + bid +
                ", spanId=" + spanId +
                ", action=" + action +
                ", source=" + source +
                ", success=" + success +
                ", data=" + data +
                '}';
    }

    public enum Action {
        @JsonProperty("request")
        REQUEST,
        @JsonProperty("response")
        RESPONSE
    }

    /**
     * Из какого топика читали ответы модерации. Имеет смысл только для Action.RESPONSE
     */
    public enum Source {
        @JsonProperty("response")
        RESPONSE,
        @JsonProperty("error")
        ERROR,
        @JsonProperty("unparsed")
        UNPARSED
    }
}
