package ru.yandex.direct.common.log.container.bidmodifiers;

import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Логируемые изменения в корректировках в формате, схожем с тем, который записывался в perl-реализации.
 */
public class LogBidModifierData {
    @JsonProperty("inserted")
    private List<LogMultiplierInfo> inserted;
    @JsonProperty("updated")
    private List<LogMultiplierInfo> updated;
    /**
     * Идентификаторы в таблицах hierarchical_multipliers, geo_multipliers_values, demography_multipliers_values,
     * retargeting_multipliers_values (указывают на конкретные корректировки, которые были удалены)
     */
    @JsonProperty("deleted")
    private List<LogMultiplierInfo> deleted;
    /**
     * Идентификатор в таблице hierarchical_multipliers, который был удалён в связи с
     * удалением всех его дочерних корректировок.
     */
    @JsonProperty("deleted_set")
    private Long deletedSet;

    @JsonProperty("enabled_changes")
    private IsEnabledChange enabledChanges;

    @JsonProperty("cid")
    private final long campaignId;
    @JsonProperty("pid")
    private final Long adGroupId;

    public LogBidModifierData(long campaignId, @Nullable Long adGroupId) {
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
    }

    public LogBidModifierData withDeleted(List<LogMultiplierInfo> deleted) {
        this.deleted = deleted;
        return this;
    }

    public LogBidModifierData withInserted(List<LogMultiplierInfo> inserted) {
        this.inserted = inserted;
        return this;
    }

    public LogBidModifierData withUpdated(List<LogMultiplierInfo> updated) {
        this.updated = updated;
        return this;
    }

    public LogBidModifierData withDeletedSet(long deletedSet) {
        this.deletedSet = deletedSet;
        return this;
    }

    public LogBidModifierData withEnabledChanges(IsEnabledChange enabledChanges) {
        this.enabledChanges = enabledChanges;
        return this;
    }

    public long getCampaignId() {
        return campaignId;
    }

    @Nullable
    public Long getAdGroupId() {
        return adGroupId;
    }

    public List<LogMultiplierInfo> getDeleted() {
        return deleted;
    }
}
