package ru.yandex.direct.common.log.container.bidmodifiers;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.dbschema.ppc.enums.HierarchicalMultipliersType;

/**
 * Информация о добавленном/изменённом элементе набора корректировок ставок.
 */
public class LogMultiplierInfo {
    @JsonProperty("id")
    private final long id;
    @JsonProperty("hierarchical_multiplier_id")
    private final Long hierarchicalMultiplierId;
    @JsonProperty("type")
    private final HierarchicalMultipliersType type;
    @JsonProperty("old_multiplier_pct")
    private final Integer oldPercent;
    @JsonProperty("new_multiplier_pct")
    private final Integer newPercent;

    public LogMultiplierInfo(long id,
                             Long hierarchicalMultiplierId,
                             HierarchicalMultipliersType type,
                             Integer oldPercent,
                             Integer newPercent) {
        this.id = id;
        this.hierarchicalMultiplierId = hierarchicalMultiplierId;
        this.type = type;
        this.oldPercent = oldPercent;
        this.newPercent = newPercent;
    }

    public long getId() {
        return id;
    }
}
