package ru.yandex.direct.common.log.container.bsexport;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;

import ru.yandex.direct.utils.JsonUtils;

public class BsExportDataSerializer<T> extends JsonSerializer<T> {
    private static final JsonFormat.Printer PROTO_PRINTER = JsonFormat.printer().omittingInsignificantWhitespace();

    @Override
    public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        String jsonValue;
        if (value instanceof MessageOrBuilder) {
            jsonValue = PROTO_PRINTER.print((MessageOrBuilder) value);
        } else {
            jsonValue = JsonUtils.toJson(value);
        }
        gen.writeRawValue(jsonValue);
    }
}
