package ru.yandex.direct.common.log.container.bsexport;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class LogBsExportEssData<T> {

    @JsonProperty("bid")
    private long bid;
    @JsonProperty("pid")
    private long pid;
    @JsonProperty("cid")
    private long cid;
    @JsonProperty("bs_banner_id")
    private long bsBannerId;
    @JsonProperty("order_id")
    private long orderId;
    @JsonProperty("strategy_id")
    private long strategyId;
    @JsonSerialize(using = BsExportDataSerializer.class)
    @JsonProperty("data")
    private T data;

    public LogBsExportEssData<T> withBid(Long bid) {
        this.bid = bid;
        return this;
    }

    public LogBsExportEssData<T> withPid(Long pid) {
        this.pid = pid;
        return this;
    }

    public LogBsExportEssData<T> withCid(Long cid) {
        this.cid = cid;
        return this;
    }

    public LogBsExportEssData<T> withBsBannerId(Long bsBannerId) {
        this.bsBannerId = bsBannerId;
        return this;
    }

    public LogBsExportEssData<T> withOrderId(Long orderId) {
        this.orderId = orderId;
        return this;
    }

    public LogBsExportEssData<T> withStrategyId(Long strategyId) {
        this.strategyId = strategyId;
        return this;
    }

    public LogBsExportEssData<T> withData(T data) {
        this.data = data;
        return this;
    }

}
