package ru.yandex.direct.common.log.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.log.LogHelper;
import ru.yandex.direct.common.log.container.LogEntry;
import ru.yandex.direct.common.log.container.LogType;
import ru.yandex.direct.common.log.container.bidmodifiers.LogBidModifierData;
import ru.yandex.direct.utils.JsonUtils;

/**
 * Сервис, логирующий изменения в корректировках ставок.
 */
@Service
public class LogBidModifiersService {
    private static final LogType LOG_TYPE = LogType.BID_MODIFIERS;
    private static final String LOGGER_NAME = "PPCLOG_BIDMODIFIERS.log";

    private final LogHelper logHelper;

    private final Logger logger = LoggerFactory.getLogger(LOGGER_NAME);

    @Autowired
    public LogBidModifiersService() {
        this.logHelper = new LogHelper(LOG_TYPE);
    }

    public void logBidModifiers(List<LogBidModifierData> logDataList, long uid) {
        logHelper.getPartitionedEntriesStream(logDataList, uid)
                .map(this::entryToString)
                .forEach(logger::info);
    }

    private String entryToString(LogEntry<?> logEntry) {
        return JsonUtils.toJson(logEntry);
    }
}
