package ru.yandex.direct.common.log.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.log.LogHelper;
import ru.yandex.direct.common.log.container.LogMailsData;
import ru.yandex.direct.common.log.container.LogType;
import ru.yandex.direct.utils.JsonUtils;

/**
 * Сервис логирующий отправку писем.
 * <pre>
 *     {"log_time":"2019-10-31 01:55:46","method":"unknown","service":"unknown",
 *     "ip":"127.0.0.1","reqid":0,"log_hostname":"192.168.1.7","log_type":"mails",
 *     "data":[{"email":"address@yandex.ru","template_name":"deal_notification",
 *         "subject":"New campaign","content":"New campaign created"}]
 *     }
 * </pre>
 */
@Service
public class LogMailsFileService {
    private static final String LOGGER_NAME = "MAILS.log";
    private static final Logger MAILS_LOGGER = LoggerFactory.getLogger(LOGGER_NAME);

    private final LogHelper logHelper;

    public LogMailsFileService() {
        this.logHelper = new LogHelper(LogType.MAILS);
    }

    public void logMails(List<LogMailsData> mails) {
        logHelper.getPartitionedEntriesStream(mails, null)
                .map(JsonUtils::toJson)
                .forEach(MAILS_LOGGER::info);
    }
}
