package ru.yandex.direct.common.log.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.log.LogHelper;
import ru.yandex.direct.common.log.container.LogType;
import ru.yandex.direct.common.log.container.LogUaasData;
import ru.yandex.direct.utils.JsonUtils;

/**
 * Сервис логирующий информацию abt фичах
 * Пример записи:
 * <pre>
 * {
 * "uid" : 1,
 * "method" : "...",
 * "service" : "direct.web",
 * "ip" : "127.0.0.1",
 * "reqid" : 4303498255735922629,
 * "log_hostname" : "77.88.0.36-spb.dhcp.yndx.net",
 * "log_time" : "2017-05-11 15:18:27",
 * "log_type" : "ppclog_price",
 * "data" : [
 * {"ClientID":"123",
 * "yandexuid":"5058944161556279128",
 * "exp_boxes":"194899,0,81;190412,0,17",
 * "features":"test_feature_client_4, test_feature_client_3"}
 * ]
 * }
 * </pre>
 */
@Service
public class LogUaasDataService {

    private static final String LOGGER_NAME = "UAAS_DATA.log";
    private static final Logger UAAS_DATA_LOGGER = LoggerFactory.getLogger(LOGGER_NAME);

    private final LogHelper logHelper;

    public LogUaasDataService() {
        this.logHelper = new LogHelper(LogType.UAAS_DATA);
    }

    /**
     * Добавить в лог запись об abt фичах
     */
    public void logUaasData(LogUaasData logDataList) {
        UAAS_DATA_LOGGER.info(JsonUtils.toJson(logHelper.getLogEntry(logDataList)));
    }
}
