package ru.yandex.direct.common.log.service;

import java.time.LocalDateTime;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.direct.common.log.container.ModerationLogEntry;
import ru.yandex.direct.tracing.Trace;
import ru.yandex.direct.utils.JsonUtils;

import static ru.yandex.direct.common.log.LogHelper.DATE_TIME_FORMATTER;

@Service
public class ModerationLogService {
    private static final String LOGGER_NAME = "MODERATION.log";
    private final Logger logger = LoggerFactory.getLogger(LOGGER_NAME);

    public <T> void logEvent(ModerationLogEntry<T> moderationLogEntry) {
        moderationLogEntry.setLogTime(LocalDateTime.now().format(DATE_TIME_FORMATTER));
        moderationLogEntry.setSpanId(Trace.current().getSpanId());
        logger.info(JsonUtils.toJson(moderationLogEntry));
    }
}
