package ru.yandex.direct.common.log.service.metrics;

import java.util.Map;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MetricData {
    private String name;

    private double value;

    private Map<String, String> context;

    public MetricData() {
    }

    public MetricData(String name, double value, Map<String, String> context) {
        this.name = name;
        this.value = value;
        this.context = context;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getValue() {
        return value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public Map<String, String> getContext() {
        return context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public void addCommonContext(Map<String, String> commonContext) {
        commonContext.forEach(context::putIfAbsent);
    }
}
