package ru.yandex.direct.common.logging;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.jetty.http.HttpStatus;

/**
 * Типы результатов выполнения хендла
 */
public enum EventType {
    /**
     * Использовать дефолтное значение
     */
    DEFAULT,

    /**
     * Никакие
     */
    NONE,

    /**
     * Только ошибочные (с кодами ответа {@link HttpStatus#BAD_REQUEST_400} и выше)
     */
    ERRORS,

    /**
     * Все (успешные и ошибочные)
     */
    ALL;

    boolean isNeeded(@Nonnull HttpServletResponse response) {
        switch (this) {
            case ALL:
                return true;
            case ERRORS:
                return response.getStatus() >= HttpStatus.BAD_REQUEST_400;
            default:
                return false;
        }
    }
}
