package ru.yandex.direct.common.logging;

import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

/**
 * Обертка для записи лога. Своя для каждого запроса.
 */
@Component
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class LogRecordHolder<T extends LogRecord> {

    private T logRecord;

    public T getLogRecord() {
        return logRecord;
    }

    public void setLogRecord(T logRecord) {
        this.logRecord = logRecord;
    }
}
