package ru.yandex.direct.common.logging;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Настройки логирования, используемые {@link ru.yandex.direct.common.logging.LoggingFilter}
 * Чтение настроек реализовано в {@link ru.yandex.direct.common.logging.LoggingConfigurerInterceptor}
 * <p>
 * Примечание: умолчательные значения описаны прямо здесь а не где бы то ни было в виде констант,
 * потому что другие варианты не работают с Enum полями.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface LoggingConfig {
    int DEFAULT_BODY_SIZE = 0;

    /**
     * Включено ли логирование
     */
    EventType enabled() default EventType.DEFAULT;

    /**
     * Для каких результатов выполнения нужно логировать тело запроса
     */
    EventType logRequestBody() default EventType.DEFAULT;

    /**
     * Максимальный размер запроса для логировани (в байтах). 0 - использовать дефолтный размер
     */
    int maxRequestBodySize() default DEFAULT_BODY_SIZE;

    /**
     * Для каких результатов выполнения нужно логировать тело ответа
     */
    EventType logResponseBody() default EventType.DEFAULT;

    /**
     * Максимальный размер ответа для логировани (в байтах). 0 - использовать дефолтный размер
     */
    int maxResponseBodySize() default DEFAULT_BODY_SIZE;
}
