package ru.yandex.direct.common.logging;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import static ru.yandex.direct.common.logging.LoggingConfigurationUtils.saveConfig;

/**
 * Читает с {@code handler} аннотацию {@link LoggingConfig}
 * Сохраняет настройки логирования (если есть) в аттрибутах {@code request}
 * Включает логирование в {@code ProxyResponseWrapper}'е если нужно
 */
@ParametersAreNonnullByDefault
public class LoggingConfigurerInterceptor extends HandlerInterceptorAdapter {
    private final LoggingSettings loggingDefaults;

    public LoggingConfigurerInterceptor(LoggingSettings loggingDefaults) {
        this.loggingDefaults = loggingDefaults;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {
        if (handler instanceof HandlerMethod) {
            LoggingConfig config = ((HandlerMethod) handler).getMethodAnnotation(LoggingConfig.class);
            LoggingSettings settings = loggingDefaults;
            if (config != null) {
                saveConfig(request, config);
                settings = settings.withConfig(config);
            }

            if (settings.enabled() != EventType.NONE && settings.logResponseBody() != EventType.NONE
                    && response instanceof ProxyResponseWrapper) {
                ProxyResponseWrapper wrappedResponse = (ProxyResponseWrapper) response;
                wrappedResponse.enableLogger(settings.maxResponseBodySize());
            }
        }
        return true;
    }
}
