package ru.yandex.direct.common.logging;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestBodyLogWriter<T extends LogRecord> {

    protected final LogRecordHolder<T> logRecordHolder;

    @Autowired
    public RequestBodyLogWriter(LogRecordHolder<T> logRecordHolder) {
        this.logRecordHolder = logRecordHolder;
    }

    /**
     * Записывает объект из post запроса в лог, если фильтр логирования работает
     */
    public void writeBodyToLog(Object requestBodyArgument) {
        LogRecord logRecord = logRecordHolder.getLogRecord();
        //может быть null, например, в тестах, если фильтры отключены, так как logRecord создается в фильтре
        if (logRecord == null) {
            return;
        }
        //основное тело логируем в LoggingFilter, чтобы учитывать ограничения размера запроса

        if (requestBodyArgument instanceof RequestWithCampaignId) {
            RequestWithCampaignId requestWithCampaignId = (RequestWithCampaignId) requestBodyArgument;
            logRecord.setCids(requestWithCampaignId.getCampaignIds());
            logRecord.setPids(requestWithCampaignId.getAdGroupIds());
            logRecord.setBids(requestWithCampaignId.getBannerIds());
        }
    }
}
