package ru.yandex.direct.common.metrics;

import java.lang.reflect.Method;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

/**
 * Интерсептор, для совместной работы с MetricsFilter - запоминает вызываемый метод.
 *
 * @see MetricsFilter
 */
@Component
@ParametersAreNonnullByDefault
public class MetricsInterceptor extends HandlerInterceptorAdapter {
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod) handler;
            Method method = handlerMethod.getMethod();
            request.setAttribute(MetricsFilter.METHOD_ATTRIBUTE_NAME, method);
        }
        return true;
    }
}
