package ru.yandex.direct.common.mobilecontent;

import java.util.Map;
import java.util.Optional;

import one.util.streamex.StreamEx;

import static java.util.function.Function.identity;

/**
 * Типы магазинов приложений для РМП
 */
public enum MobileContentStoreType {
    GOOGLE_PLAY("gplay"),
    ITUNES("itunes");

    private static final Map<String, MobileContentStoreType> TYPES_BY_NAME = StreamEx
            .of(MobileContentStoreType.values())
            .toMap(MobileContentStoreType::getName, identity());

    final String name;

    MobileContentStoreType(String name) {
        this.name = name;
    }

    public static MobileContentStoreType byName(String name) {
        return Optional.ofNullable(TYPES_BY_NAME.get(name.toLowerCase()))
                .orElseThrow(() -> new IllegalArgumentException("Type not found: " + name));
    }

    public String getName() {
        return name;
    }
}

