package ru.yandex.direct.common.mobilecontent;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class MobileContentYtTablesConfig {
    private final Map<String, MobileContentYtTable> shopInfo;

    public MobileContentYtTablesConfig(Map<String, MobileContentYtTable> shopInfo) {
        this.shopInfo = Collections.unmodifiableMap(shopInfo);
    }

    public Map<String, MobileContentYtTable> getAllShops() {
        return shopInfo;
    }

    public Optional<MobileContentYtTable> getShopInfo(String shopName) {
        return Optional.ofNullable(shopInfo.get(shopName));
    }
}
