package ru.yandex.direct.common.net;

import java.math.BigInteger;

public class IpConstants {
    //число бит в IPv6-адресе
    public static final int IPV6_ADDRESS_BITS_COUNT = 128;
    //число бит в IPv4-адресе
    public static final int IPV4_ADDRESS_BITS_COUNT = 32;

    //128 взведенных бит
    public static final BigInteger IPV6_ONES =
            BigInteger.ONE.shiftLeft(IPV6_ADDRESS_BITS_COUNT).subtract(BigInteger.ONE);

    //32 взведенных бита
    public static final BigInteger IPV4_ONES =
            BigInteger.ONE.shiftLeft(IPV4_ADDRESS_BITS_COUNT).subtract(BigInteger.ONE);

    //(16 + 32) взведенных бита
    public static final BigInteger IPV4_TO_IPV6_TRANSLATION_ONES =
            BigInteger.ONE.shiftLeft(IPV4_ADDRESS_BITS_COUNT + 16).subtract(BigInteger.ONE);

    //16 взведенных бит, за которыми идут 32 сброшенных. Нужны для трансляции IPv4 в IPv6
    public static final BigInteger IPV4_TO_IPV6_TRANSLATION_PREFIX =
            IPV4_TO_IPV6_TRANSLATION_ONES.subtract(IPV4_ONES);

    private IpConstants() {
    }
}
