package ru.yandex.direct.common.net;

import java.math.BigInteger;

/**
 * Инкапсулирует тип и свойства IP-протокола.
 */
enum IpFamilyType {
    IPV4(IpConstants.IPV4_ONES, IpConstants.IPV4_ADDRESS_BITS_COUNT),
    IPV6(IpConstants.IPV6_ONES, IpConstants.IPV6_ADDRESS_BITS_COUNT);

    private final int bitsCount;
    private final BigInteger familyOnes;

    IpFamilyType(BigInteger familyOnes, int bitsCount) {
        this.familyOnes = familyOnes;
        this.bitsCount = bitsCount;
    }

    /**
     * @return число бит в адресе
     */
    public int getBitsCount() {
        return bitsCount;
    }

    /**
     * @return единичную маску длиной #{@link #getBitsCount()}
     */
    public BigInteger getFamilyOnes() {
        return familyOnes;
    }
}
