package ru.yandex.direct.common.net;

/**
 * Типизированное имя сети.
 * Предполагается, что соответствующая сеть зарегистрирована в {@link ru.yandex.direct.common.net.NetAcl}
 * Для добавления сети необходимо положить файл metrika.tmpl в /direct/perl/data/t/prebuild/networks
 */
public enum NetworkName {
    BSNETS("bsnets"),
    DISPLAY("display"),
    METRIKA("metrika"),
    INTERNAL("internal"),
    BROADMATCH("broadmatch"),
    DIRECT_MOD("directmod"),
    DIRECT_MOD_TEST("directmod_test"),
    BALANCE_BACKEND("balance_backend"),
    LAUNCHER("launcher"),
    DIRECT_PRODUCTION("direct_prod");

    private final String networkName;

    NetworkName(String networkName) {
        this.networkName = networkName;
    }

    /**
     * @return имя сети в {@link ru.yandex.direct.common.net.NetAcl}
     */
    public String networkName() {
        return networkName;
    }
}
