package ru.yandex.direct.common.spring;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

/**
 * Для пометки компонентов, управляемых spring конфигурацией, чтобы загружать эти компоненты
 * в дев конфиге {@link ru.yandex.direct.env.EnvironmentType#DEVELOPMENT}
 */
@Component
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@Conditional(OnlyForDevelopmentCondition.class)
public @interface DevelopmentComponent {
}
