package ru.yandex.direct.common.spring;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import ru.yandex.direct.env.Environment;

@ParametersAreNonnullByDefault
public class OnlyForProductionCondition implements Condition {

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return Environment.getCached().isProductionOrPrestable();
    }
}
