package ru.yandex.direct.common.spring;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

/**
 * Для пометки компонентов, управляемых spring конфигурацией, чтобы не загружать эти компоненты в прод конфиге
 * {@link ru.yandex.direct.env.EnvironmentType#PRODUCTION}
 * <p>
 * Аннотация <b>не должна</b> применяться для сервисов,
 * которые в итоге хочется дать <b>внешним</b> пользователям.
 * Если разрабатываешь новую продуктовую функциональность, то использовать её не стоит.
 */
@Component
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@Conditional(OnlyForTestingCondition.class)
public @interface TestingComponent {
}
