package ru.yandex.direct.common.tracing;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;

import ru.yandex.direct.tracing.Trace;

/**
 * Заголовок {@value HEADER_NAME} HTTP-ответа сервисов API.
 * <p>
 * Содержит ID запроса – {@code reqid}, название вызванного сервиса и метода – {@code cmd},
 * а также произвольный набор строковых переменных (для API5 это, например, appcode).
 * {@code reqid} и {@code cmd} берутся из TraceHolder-а в момент создания объекта.
 * <p>
 * Нужен для мониторинга проблем по логам nginx.
 */
@ParametersAreNonnullByDefault
public class AccelInfoHeader {
    public static final String HEADER_NAME = "X-Accel-Info";

    private static final String FORMAT = "reqid:%d,cmd:%s/%s";

    private final String stringValue;

    public AccelInfoHeader(Map<String, String> vars) {
        Long reqid = Trace.current().getSpanId();
        String service = Trace.current().getService();
        String cmd = Trace.current().getMethod();

        this.stringValue = String.format(FORMAT, reqid, service, cmd)
                + EntryStream.of(vars).mapKeyValue((k, v) -> "," + k + ":" + v).joining();
    }

    @Override
    public String toString() {
        return stringValue;
    }
}
