package ru.yandex.direct.common.util;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.env.Environment;
import ru.yandex.direct.graphite.GraphiteMetricsBuffer;

@ParametersAreNonnullByDefault
public class DirectGraphiteUtils {
    private static final String BASE_GRAPHITE_PREFIX = "direct_one_min.db_configurations";
    private static final String FLOW_PREFIX = "flow";

    private DirectGraphiteUtils() {
    }

    /**
     * Получить {@link GraphiteMetricsBuffer} инициализированный префиксом по умолчанию, состоящим из
     * {@code BASE_GRAPHITE_PREFIX} и legacy-имени текущей конфигурации
     */
    public static GraphiteMetricsBuffer defaultBuffer() {
        return new GraphiteMetricsBuffer(BASE_GRAPHITE_PREFIX, Environment.getCached().getLegacyName());
    }

    /**
     * Получить {@link GraphiteMetricsBuffer} инициализированный префиксом по умолчанию, состоящим из
     * {@code BASE_GRAPHITE_PREFIX}, legacy-имени текущей конфигурации и префиксом "flow"
     */
    public static GraphiteMetricsBuffer flowBuffer() {
        return new GraphiteMetricsBuffer(BASE_GRAPHITE_PREFIX, Environment.getCached().getLegacyName(), FLOW_PREFIX);
    }
}
