package ru.yandex.direct.common.util;

import java.nio.charset.StandardCharsets;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Utility class for text encoding stuff
 */
@ParametersAreNonnullByDefault
public class EncodingUtils {
    private EncodingUtils() {
    }

    /**
     * Sometimes, we have deal with string, twice encoded to UTF8,
     * method breaks encoding of String the same way
     */
    public static String doubleUtf8Encode(String data) {
        return new String(data.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
    }

    /**
     * Sometimes, we have deal with string, twice encoded to UTF8,
     * method fixes encoding of string
     */
    public static String doubleUtf8Decode(String data) {
        return new String(data.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
    }

    /**
     * Метод исправляет двойное кодирование, только если строка похожа на битую
     */
    public static String recoverUtf8Decode(String data) {
        if (data.indexOf('\u00d0') != -1 || data.indexOf('\u00d1') != -1) {
            return doubleUtf8Decode(data);
        } else {
            return data;
        }
    }
}
