package ru.yandex.direct.common.util;

import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * Дополнительные бинарные операции
 */
public final class MoreBinaryOperators {
    private MoreBinaryOperators() {
    }

    /**
     * Для использования в {@link java.util.stream.Collectors#toMap(Function, Function, BinaryOperator, Supplier)}
     */
    public static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    /**
     * Для построения кастомных Collector-ов
     */
    public static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(BinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry<K, V> e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        };
    }
}
