package ru.yandex.direct.common.util;

import java.time.Duration;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.utils.HashingUtils;

import static java.lang.String.format;

@ParametersAreNonnullByDefault
public class TuneSecretKey {
    private TuneSecretKey() {
    }

    public static String generateSecretKey(@Nullable Long uid) {
        long days = Duration.ofMillis(System.currentTimeMillis()).toDays();
        String yandexUidCookie =
                uid != null ? null : HttpUtil.getCookieValue("yandexuid", HttpUtil.getRequest()).orElse(null);

        return generateSecretKey(days, uid, yandexUidCookie);
    }

    /**
     * Сгенерировать ключ для изменения языка в tune.yandex.ru
     * http://wiki.yandex-team.ru/AlekseyPonomarev/secret-key
     * <p>
     * Если uid и yandexUidCookie равны null то метод вернет null
     */
    @Nullable
    public static String generateSecretKey(long days, @Nullable Long uid, @Nullable String yandexUidCookie) {
        String secretKey = null;
        if (uid != null) {
            secretKey = "u" + HashingUtils.getMd5HashUtf8AsHexString(format("%d::%d", uid, days));
        } else if (yandexUidCookie != null) {
            secretKey = "y" + HashingUtils.getMd5HashUtf8AsHexString(format("0:%s:%d", yandexUidCookie, days));
        }

        return secretKey;
    }
}
