package ru.yandex.direct.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

import org.apache.commons.io.IOUtils;


/**
 * Используется утилитой dt-java-hotfix для сравнения скомпилированных классов с классами из classpath приложения
 */
public class WriteClassToStdoutTool {

    private WriteClassToStdoutTool() {
    }

    public static void main(String[] args) throws ClassNotFoundException, IOException {
        if (args.length != 1) {
            System.out.println(String.format("Usage: %s className", WriteClassToStdoutTool.class.getCanonicalName()));
        } else {
            String className = args[0];
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            String classFileName = clazz.getName().replace('.', '/') + ".class";
            InputStream classStream = clazz.getClassLoader().getResourceAsStream(classFileName);

            Objects.requireNonNull(classStream);
            IOUtils.copy(classStream, System.out);
        }
    }
}
