package ru.yandex.direct.core;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

public interface CommonTranslations extends TranslationBundle {

    CommonTranslations INSTANCE = I18NBundle.implement(CommonTranslations.class);

    @TranslationStub("Сервис временно недоступен")
    Translatable serviceUnavailable();

    @MessageFormatStub("Внутренняя ошибка сервера")
    Translatable serviceInternalError();

    @MessageFormatStub("Превышен лимит ожидания запроса")
    Translatable timeLimitExceeded();
}
