package ru.yandex.direct.core.aggregatedstatuses;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdStates;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;
import ru.yandex.direct.core.entity.aggregatedstatuses.ad.AdStatesEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.ad.AggregatedStatusAdData;
import ru.yandex.direct.core.entity.banner.aggrstatus.StatusAggregationBanner;

import static ru.yandex.direct.core.aggregatedstatuses.logic.SelfStatusCalculators.calcAdSelfStatus;

@ParametersAreNonnullByDefault
public final class AdChangesProcessor {
    public ChangesResult changes(List<BannerDataForStatus> bannersDataForStatus) {
        final var adStates = new AdStates();
        final var statuses = new HashMap<Long, AggregatedStatusAdData>();

        for (var data : bannersDataForStatus) {
            Collection<AdStatesEnum> states = adStates.calc(data.banner());
            SelfStatus selfStatus = calcAdSelfStatus(states, data.reasons());
            states.addAll(adStates.calcStatesByStatus(selfStatus, states));
            statuses.put(data.banner().getId(), new AggregatedStatusAdData(states, selfStatus));
        }

        final var adGroupIds = bannersDataForStatus.stream()
                .map(BannerDataForStatus::banner)
                .map(StatusAggregationBanner::getAdgroupId)
                .collect(Collectors.toList());

        return new ChangesResult(statuses, adGroupIds);
    }
}
