package ru.yandex.direct.core.aggregatedstatuses;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.core.entity.aggregatedstatuses.ad.AggregatedStatusAdData;
import ru.yandex.direct.core.entity.aggregatedstatuses.adgroup.AggregatedStatusAdGroupData;
import ru.yandex.direct.core.entity.aggregatedstatuses.campaign.AggregatedStatusCampaignData;
import ru.yandex.direct.core.entity.aggregatedstatuses.keyword.AggregatedStatusKeywordData;
import ru.yandex.direct.core.entity.aggregatedstatuses.retargeting.AggregatedStatusRetargetingData;
import ru.yandex.direct.dbutil.model.ClientId;

public interface AggregatedStatuses {
    Map<Long, AggregatedStatusCampaignData> getCampaignStatusesByIds(int shard, Collection<Long> cids);
    Map<Long, AggregatedStatusAdData> getAdStatusesByIds(int shard, Set<Long> bids);
    Map<Long, AggregatedStatusAdGroupData> getAdGroupStatusesByCampaignId(int shard, ClientId clientId, Long campaignId);
    Map<Long, AggregatedStatusAdData> getAdStatusesByAdgroupIds(int shard, ClientId clientId, Collection<Long> adgroupIds);
    Map<Long, AggregatedStatusKeywordData> getKeywordStatusesByAdgroupIds(int shard, ClientId clientId, Collection<Long> adgroupIds);
    Map<Long, AggregatedStatusRetargetingData> getRetargetingStatusesByAdgroupIds(int shard, ClientId clientId, Collection<Long> adgroupIds);
    Map<Long, AggregatedStatusAdGroupData> getAdGroupStatusesByIds(int shard, Set<Long> pids);
}
