package ru.yandex.direct.core.aggregatedstatuses;

import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.aggrstatus.StatusAggregationBanner;
import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagType;

@ParametersAreNonnullByDefault
public final class BannerDataForStatus {
    private final StatusAggregationBanner banner;
    private final Map<ModerationDiagType, Set<Long>> reasons;

    public BannerDataForStatus(StatusAggregationBanner banner,
                               Map<ModerationDiagType, Set<Long>> reasons) {
        this.banner = banner;
        this.reasons = reasons;
    }

    public StatusAggregationBanner banner() {
        return banner;
    }

    public Map<ModerationDiagType, Set<Long>> reasons() {
        return reasons;
    }
}
